/**
 * External dependencies
 */
import classnames from 'classnames';

const fontAwesomeVersion = window.MinervaKB.settings.font_awesome_version;
const isFontAwesomeV4 = fontAwesomeVersion === 'v4';

export const Icon = ({ value, extraClasses = '' }) => {
    const isOlderVersionIcon = fontAwesomeVersion === 'v5' && !['fas ', 'far '].includes(value.substring(0, 4));

    return (
        <i className={classnames(
            (isFontAwesomeV4 || isOlderVersionIcon) && 'fa',
            value,
            extraClasses
        )} />
    );
};
